<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: ../login.php");
  exit;
}

include "../koneksi.php";
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Admin</title>

<style>
body{
  font-family:'Segoe UI',sans-serif;
  background:#f5f7f2;
}
.container{
  max-width:1100px;
  margin:40px auto;
}
h2{color:#2F6F4E;margin-bottom:20px}
table{
  width:100%;
  border-collapse:collapse;
  background:#fff;
}
th,td{
  padding:12px 14px;
  border-bottom:1px solid #ddd;
  text-align:left;
}
th{
  background:#2F6F4E;
  color:#fff;
}
a{
  color:red;
  text-decoration:none;
}
.logout{
  float:right;
  background:#c0392b;
  color:white;
  padding:10px 18px;
  border-radius:8px;
}
</style>
</head>

<body>

<div class="container">
  <a href="../logout.php" class="logout">Logout</a>
  <h2>Dashboard Admin – Kritik & Saran</h2>

  <table>
    <tr>
      <th>No</th>
      <th>Nama</th>
      <th>Email</th>
      <th>Pesan</th>
      <th>Tanggal</th>
      <th>Aksi</th>
    </tr>

    <?php
    $no = 1;
    $data = mysqli_query($koneksi, "SELECT * FROM kritik_saran ORDER BY tanggal DESC");

    if (mysqli_num_rows($data) == 0) {
      echo "<tr><td colspan='6'>Belum ada kritik & saran</td></tr>";
    }

    while ($row = mysqli_fetch_assoc($data)) {
    ?>
    <tr>
      <td><?= $no++; ?></td>
      <td><?= htmlspecialchars($row['nama']); ?></td>
      <td><?= htmlspecialchars($row['email']); ?></td>
      <td><?= htmlspecialchars($row['pesan']); ?></td>
      <td><?= $row['tanggal']; ?></td>
      <td>
        <a href="hapus.php?id=<?= $row['id']; ?>"
           onclick="return confirm('Hapus data ini?')">
           Hapus
        </a>
      </td>
    </tr>
    <?php } ?>
  </table>
</div>

</body>
</html>
