<?php
session_start();
include "koneksi.php";
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Desa Tlompakan</title>

<style>
:root{
  --hijau-tua:#2F6F4E;
  --hijau-sawah:#6B8E23;
  --abu:#444;
  --bg:#F5F7F2;
}

*{margin:0;padding:0;box-sizing:border-box;font-family:'Segoe UI',sans-serif;}
body{background:var(--bg);color:var(--abu);line-height:1.7}

/* ================= NAVBAR ================= */
.navbar{
  background:#fff;
  position:sticky;
  top:0;
  z-index:1000;
  box-shadow:0 4px 10px rgba(0,0,0,.08)
}
.nav-container{
  max-width:1200px;
  margin:auto;
  padding:14px 24px;
  display:flex;
  align-items:center
}
.logo{
  font-weight:600;
  font-size:20px;
  color:var(--hijau-tua)
}
.nav-menu{
  list-style:none;
  display:flex;
  gap:26px;
  margin-left:auto;
}
.nav-menu a{
  text-decoration:none;
  color:var(--abu);
  font-weight:500;
}
.nav-menu a:hover{
  color:var(--hijau-tua);
}

/* Tombol Admin */
.admin-link{
  padding:6px 14px;
  border-radius:20px;
  border:1.5px solid var(--hijau-tua);
  color:var(--hijau-tua);
  font-weight:600;
}
.admin-link:hover{
  background:var(--hijau-tua);
  color:white;
}

/* ================= HEADER ================= */
header{
  background:
    linear-gradient(rgba(0,0,0,.45), rgba(0,0,0,.45)),
    url("assets/images/bg-home.jpg");
  background-size:cover;
  background-position:center;
  color:white;
  text-align:center;
  padding:130px 20px 110px;
}

/* ================= SECTION ================= */
section{
  max-width:1100px;
  margin:auto;
  padding:80px 20px;
}
section h2{
  font-size:32px;
  margin-bottom:30px;
  color:var(--hijau-tua);
}

.tentang p{
  max-width:900px;
  margin-bottom:18px;
  text-align:justify;
}

.grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:30px;
}
.card{
  background:white;
  border-radius:20px;
  padding:28px;
  box-shadow:0 12px 28px rgba(0,0,0,.08);
  transition:.3s;
}
.card:hover{transform:translateY(-6px)}
.card h3{
  color:var(--hijau-sawah);
  margin-bottom:10px;
}
.deskripsi {
  text-align: justify;
}

.umkm{background:#fff}

/* ================= FORM ================= */
.form-kritik{
  max-width:600px;
  margin-top:20px;
}
.form-kritik input,
.form-kritik textarea{
  width:100%;
  padding:14px;
  margin-bottom:14px;
  border-radius:10px;
  border:1px solid #ccc;
}
.form-kritik button{
  background:var(--hijau-tua);
  color:white;
  padding:12px 24px;
  border:none;
  border-radius:10px;
  cursor:pointer;
}
.form-kritik button:hover{
  background:var(--hijau-sawah);
}

/* ================= DASHBOARD ================= */
table{
  width:100%;
  border-collapse:collapse;
}
th,td{
  padding:12px;
  border-bottom:1px solid #ddd;
}
th{background:#f1f1f1}
.btn-logout{
  float:right;
  background:#c0392b;
  color:white;
  padding:8px 16px;
  border-radius:8px;
  text-decoration:none;
}
.btn-logout:hover{background:#e74c3c}

/* ================= FOOTER ================= */
footer{
  background:var(--hijau-tua);
  color:white;
  text-align:center;
  padding:28px 15px;
  font-size:14px;
}

@media(max-width:768px){
  .nav-menu{gap:16px}
}
</style>
</head>
<body>

<!-- ================= NAVBAR ================= -->
<nav class="navbar">
  <div class="nav-container">
    <div class="logo">Desa Tlompakan</div>
    <ul class="nav-menu">
      <li><a href="#home">Home</a></li>
      <li><a href="#galeri">Galeri</a></li>
      <li><a href="#umkm">UMKM</a></li>
      <li><a href="#kontak">Kontak</a></li>
      <li><a href="login.php" class="admin-link">Admin</a></li>
    </ul>
  </div>
</nav>

<!-- ================= HEADER ================= -->
<header id="home">
  <h1>Desa Tlompakan</h1>
  <p>Kecamatan Tuntang · Kabupaten Semarang</p>
</header>

  <!-- TENTANG DESA -->
<section class="tentang">
  <h2>Tentang Desa Tlompakan</h2>

  <p>
    Desa Tlompakan merupakan salah satu desa yang terletak di Kecamatan Tuntang, Kabupaten Semarang, dan berada di wilayah ujung utara Kecamatan Tuntang. Secara geografis, wilayah Desa Tlompakan didominasi oleh daerah perbukitan dengan kontur tanah yang sebagian besar miring. Kondisi tanah yang subur, berhumus, serta didukung ketersediaan air yang cukup menjadikan desa ini memiliki potensi besar di sektor pertanian dan kehutanan rakyat.
  </p>

  <p>
    Desa Tlompakan memiliki batas wilayah sebagai berikut:

Sebelah Utara: Desa Ngajaran

Sebelah Timur: Kecamatan Bringin

Sebelah Selatan: Desa Karanganyar

Sebelah Barat: Desa Delik

Secara administratif, Desa Tlompakan terdiri atas 5 dusun, yaitu Dusun Kebondowo, Sombron, Krajan Tlompakan, Semen, dan Muludan, dengan 6 Rukun Warga (RW) dan 21 Rukun Tetangga (RT).
  </p>

  <p>
    Jumlah penduduk Desa Tlompakan tercatat sebanyak 2.665 jiwa yang terdiri dari 1.322 jiwa penduduk laki-laki dan 1.343 jiwa penduduk perempuan, dengan jumlah kepala keluarga sebanyak 898 KK. Mayoritas masyarakat bermata pencaharian sebagai petani, buruh tani, karyawan swasta, dan wiraswasta. Kondisi ini menunjukkan bahwa sektor pertanian dan tenaga kerja masih menjadi tulang punggung perekonomian desa.
  </p>

  <p>
    Masyarakat Desa Tlompakan hidup dalam keragaman budaya yang terus dilestarikan secara turun-temurun. Nilai-nilai kearifan lokal tercermin dalam aktivitas sosial, keagamaan, serta kesenian tradisional yang masih berkembang hingga saat ini. Budaya gotong royong dan kebersamaan menjadi bagian penting dalam kehidupan bermasyarakat serta mendukung terciptanya lingkungan desa yang harmonis.
  </p>

  <p>
    Penyelenggaraan pemerintahan Desa Tlompakan dilaksanakan secara demokratis dengan melibatkan partisipasi masyarakat melalui Badan Permusyawaratan Desa (BPD). Pemerintah desa berkomitmen menjalankan tata kelola pemerintahan yang transparan, akuntabel, dan berorientasi pada pelayanan masyarakat guna mendukung pembangunan desa yang berkelanjutan.
  </p>

  <p>
    Potensi Unggulan Desa
Kegiatan ekonomi desa selama ini masih di dominasi sector pertanian, mengingat luas lahan pertanian Desa Tlompakan memang cukup luas. Ada sekitar 60 % masyarakat masih menggantungkan nasibnya pada sector ini. Sebagai Desa yang luas areal pertaniannya Tlompakan sebenarnya berpotensial sebagai pemasok hasil-hasil pertanian.

    Sayangnya, modal dasar yang cukup potensial ini kemudian tidak berarti karena sumber daya air yang tidak mendukung. Hal ini membuat warga masyarakatnya hanya mengandalkan air hujan yang sekali dalam satu tahun untuk bercocok tanam sehingga masyarakat Desa Tlompakan sebagian besar menamam padi yang merupakan tanaman andalan Desa Tlompakan 

Dengan kondisi masyarakat yang hanya bercocok tanam padi sekali setahun, secara langsung berpengaruh pada tingkat penghasilan masyarakat Desa Tlompakan, akibatnya tingkat pendapatan mereka belum seutuhnya mencukupi kebutuhan hidup, belum lagi ongkos buruh yang mahal karena harga barang kebutuhan petani tidak sebanding dengan penghasilan yang diperoleh 


  Pertumbuhan ekonomi desa
Pertumbuhan perekonomian Desa Tlompakan sepanjang tahun 2018 tahun terakhir mengalami kenaikan. Hal ini sedikit banyak dipengaruhi sikap mereka yang tidak lagi melirik sector pertanian sebagai pekerjaan. Mereka lebih tertarik dengan menjadi TKI ke luar negeri dan sebagian juga sudah banyak yang menjadi kayawan di Perusahaan / Industri.

  </p>
</section>

  <!-- KESENIAN -->
  <section>
    <h2>Kesenian Tradisional</h2>
    <div class="grid">
      <div class="card">
        <h3>Reog</h3>
        <p class="deskripsi">
          Reog merupakan salah satu kesenian tradisional yang mencerminkan nilai keberanian, kekuatan, dan semangat kebersamaan masyarakat. Kesenian ini ditampilkan melalui perpaduan tari, musik tradisional, serta tokoh-tokoh yang memiliki makna simbolis. Reog sering dipentaskan pada kegiatan adat, perayaan hari besar, dan acara resmi desa sebagai bentuk pelestarian budaya lokal. Keberadaan Reog menjadi bagian penting dalam menjaga identitas budaya serta memperkuat rasa kebanggaan masyarakat terhadap warisan seni tradisional.
        </p>
      </div>
      <div class="card">
        <h3>Karawitan</h3>
        <p class="deskripsi">
          Karawitan adalah seni musik tradisional Jawa yang menggunakan seperangkat gamelan sebagai unsur utama. Kesenian ini berperan penting dalam mendukung berbagai kegiatan adat, keagamaan, dan sosial di Desa Tlompakan. Alunan musik Karawitan mencerminkan nilai keharmonisan, ketertiban, dan kebersamaan dalam kehidupan bermasyarakat. Selain sebagai hiburan, Karawitan juga menjadi sarana pelestarian budaya serta media pembinaan seni bagi generasi muda desa.
        </p>
      </div>
      <div class="card">
        <h3>Kuda Lumping</h3>
        <p class="deskripsi">
          Kuda Lumping merupakan tarian tradisional yang menggambarkan semangat keberanian dan kebersamaan masyarakat. Tarian ini menggunakan properti kuda tiruan dari anyaman bambu dan ditampilkan secara berkelompok dengan iringan musik tradisional. Kuda Lumping kerap dipentaskan dalam acara adat, perayaan desa, dan kegiatan budaya sebagai bentuk ekspresi seni rakyat. Kesenian ini memiliki nilai budaya yang tinggi dan menjadi salah satu daya tarik seni tradisional yang terus dilestarikan oleh masyarakat Desa Tlompakan.
        </p>
      </div>
    </div>
  </section>

  <!-- GALERI FOTO -->
  <section id="galeri">
    <h2>Galeri Foto Desa & UMKM</h2>
    <div class="grid">
      <div class="card">
        <img src="assets/images/sawah.jpg" alt="Sawah Desa Tlompakan" style="width:100%; border-radius:12px; margin-bottom:12px;">
        <h3>Persawahan Desa</h3>
        <p>Pemandangan sawah hijau yang menjadi ciri khas Desa Tlompakan.</p>
      </div>
      <div class="card">
        <img src="assets/images/umkmtempe.jpg" alt="UMKM Tempe" style="width:100%; border-radius:12px; margin-bottom:12px;">
        <h3>UMKM Tempe</h3>
        <p>Proses pembuatan tempe dengan bungkus daun pisang.</p>
      </div>
      <div class="card">
        <img src="assets/images/umkm-keripik.jpg" alt="UMKM Keripik" style="width:100%; border-radius:12px; margin-bottom:12px;">
        <h3>UMKM Keripik</h3>
        <p>Keripik talas dan singkong hasil olahan masyarakat desa.</p>
      </div>
      <div class="card">
        <img src="assets/images/anyaman.jpg" alt="Kerajinan Anyaman" style="width:100%; border-radius:12px; margin-bottom:12px;">
        <h3>Kerajinan Anyaman</h3>
        <p>Produk anyam ramah lingkungan.</p>
      </div>
    </div>
  </section>

  <!-- UMKM -->
  <section id="umkm" class="umkm">
    <h2>UMKM Unggulan Desa</h2>
    <div class="grid">
      <div class="card">
        <h3>Tempe Gendok</h3>
        <p class="deskripsi">
          Tempe Gendok merupakan produk pangan khas Desa Tlompakan yang dibuat dari bahan baku kedelai berkualitas dan dibungkus menggunakan daun pisang. Proses pengolahan yang masih mempertahankan cara tradisional menghasilkan cita rasa alami yang khas serta aroma yang menggugah selera. Produk ini tidak hanya menjadi konsumsi harian masyarakat, tetapi juga menjadi salah satu identitas kuliner desa yang memiliki potensi ekonomi dan nilai budaya lokal.
        </p>
      </div>
      <div class="card">
        <h3>Keripik Talas & Singkong</h3>
        <p class="deskripsi">
          Keripik Talas dan Singkong merupakan olahan hasil pertanian lokal Desa Tlompakan yang diolah secara higienis dan berkelanjutan. Dengan tekstur yang renyah serta cita rasa gurih, produk ini menjadi camilan favorit masyarakat dan memiliki daya saing sebagai produk UMKM desa. Pengembangan keripik ini turut mendorong pemanfaatan hasil bumi lokal serta meningkatkan nilai tambah bagi pelaku usaha desa.
        </p>
      </div>
      <div class="card">
        <h3>Kerajinan Tempat Sampah Anyam</h3>
        <p class="deskripsi">
          Kerajinan tempat sampah anyam merupakan produk UMKM yang mengedepankan kreativitas serta kepedulian terhadap lingkungan. Terbuat dari bahan anyaman yang ramah lingkungan, produk ini memiliki fungsi praktis sekaligus nilai estetika. Kerajinan ini menjadi wujud inovasi masyarakat Desa Tlompakan dalam menghasilkan produk bernilai guna dan bernilai jual, serta mendukung upaya pengelolaan lingkungan yang berkelanjutan.
        </p>
      </div>
    </div>
  </section>

  <!-- KONTAK & KRITIK SARAN -->
<section id="kontak">
  <h2>Kontak Desa</h2>

  <p><strong>Alamat:</strong> Desa Tlompakan, Kecamatan Tuntang, Kabupaten Semarang</p>
  <p><strong>Email:</strong> tlompakandesa@email.com</p>
  <p><strong>Telepon:</strong> 0881-3887-978</p>

  <h3 style="margin-top:40px;">Kritik & Saran</h3>

  <form action="simpan_kritik.php" method="POST" class="form-kritik">
    <input type="text" name="nama" placeholder="Nama Anda" required>
    <input type="email" name="email" placeholder="Email (opsional)">
    <textarea name="pesan" placeholder="Tulis kritik atau saran Anda..." required></textarea>
    <button type="submit">Kirim</button>
  </form>
</section>


  <!-- FOOTER -->
  <footer>
    Desa Tlompakan · Kecamatan Tuntang · Kabupaten Semarang
  </footer>

</body>
</html>
